package com.yd.user.feign.fallback.systenant;

import com.yd.common.result.Result;
import com.yd.user.feign.client.systenant.ApiSysTenantFeignClient;
import com.yd.user.feign.request.systenant.ApiSysTenantAddRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantEditRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务-系统租户信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysTenantFeignFallbackFactory implements FallbackFactory<ApiSysTenantFeignClient> {
    @Override
    public ApiSysTenantFeignClient create(Throwable cause) {
        return new ApiSysTenantFeignClient() {
            @Override
            public Result page(ApiSysTenantPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiSysTenantDetailResponse> detail(String tenantBizId) {
                return null;
            }

            @Override
            public Result add(ApiSysTenantAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSysTenantEditRequest request) {
                return null;
            }

            @Override
            public Result del(String tenantBizId) {
                return null;
            }

            @Override
            public Result editStatus(String tenantBizId, Integer status) {
                return null;
            }
        };
    }
}
