package com.yd.user.feign.fallback.reluserrole;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reluserrole.ApiRelUserRoleFeignClient;
import com.yd.user.feign.request.reluserrole.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务：用户-角色关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelUserRoleFeignFallbackFactory implements FallbackFactory<ApiRelUserRoleFeignClient> {
    @Override
    public ApiRelUserRoleFeignClient create(Throwable cause) {
        return new ApiRelUserRoleFeignClient() {

            @Override
            public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result delTenantUserRoleList(ApiTenantUserRoleListDelRequest request) {
                return null;
            }

            @Override
            public Result candidateTenantUserRolePage(ApiCandidateTenantUserRolePageRequest request) {
                return null;
            }

            @Override
            public Result selectedTenantUserRolePage(ApiSelectedTenantUserRolePageRequest request) {
                return null;
            }

            @Override
            public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result delProjectUserRoleList(ApiProjectUserRoleListDelRequest request) {
                return null;
            }

            @Override
            public Result candidateProjectUserRolePage(ApiCandidateProjectUserRolePageRequest request) {
                return null;
            }

            @Override
            public Result selectedProjectUserRolePage(ApiSelectedProjectUserRolePageRequest request) {
                return null;
            }
        };
    }
}
