package com.yd.user.feign.fallback.reltenantrole;

import com.yd.common.result.Result;
import com.yd.user.feign.client.reltenantrole.ApiRelTenantRoleFeignClient;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListAddRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;

/**
 * 用户服务：租户-角色关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelTenantRoleFeignFallbackFactory implements FallbackFactory<ApiRelTenantRoleFeignClient> {
    @Override
    public ApiRelTenantRoleFeignClient create(Throwable cause) {
        return new ApiRelTenantRoleFeignClient() {
            @Override
            public Result page(ApiRelTenantRoleListPageRequest request) {
                return null;
            }

            @Override
            public Result addRoleList(ApiRelTenantRoleListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result selectRolePage(ApiRelTenantRoleSelectPageRequest request) {
                return null;
            }
        };
    }
}
