package com.yd.user.feign.client.reltenantmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantmenu.ApiRelTenantMenuFeignFallbackFactory;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuTreeListRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuTreeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户服务：租户-菜单关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantMenuFeignFallbackFactory.class)
public interface ApiRelTenantMenuFeignClient {

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelTenantMenuListPageRequest request);

    /**
     * 租户和菜单关系树形列表查询
     * @param request
     * @return
     */
    @PostMapping("/tree")
    Result<List<ApiRelTenantMenuTreeListResponse>> tree(@Validated @RequestBody ApiRelTenantMenuTreeListRequest request);

    /**
     * 添加租户和菜单列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/menu/list")
    Result addMenuList(@Validated @RequestBody ApiRelTenantMenuListAddRequest request);

    /**
     * 删除租户和菜单关系
     * @param id 租户和菜单关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和菜单关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-树形菜单查询
     * @param request
     * @return
     */
    @PostMapping("/import/query/menu/tree")
    Result<List<ApiRelTenantMenuImportQueryMenuTreeResponse>> importQueryMenuTree(@Validated @RequestBody ApiRelTenantMenuImportQueryMenuTreeRequest request);

    /**
     * 导入-树形菜单-查询选中的菜单id集合
     * @param tenantBizId
     * @return
     */
    @GetMapping("/import/query/selected/menu/list")
    Result<List<String>> selectedList(@NotBlank(message = "租户id不能为空") @RequestParam(value = "tenantBizId") String tenantBizId);
}
