package com.yd.user.feign.client.relprojectuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.relprojectuser.ApiRelProjectUserFeignFallbackFactory;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListAddRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 用户服务：项目-用户关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelProjectUserFeignFallbackFactory.class)
public interface ApiRelProjectUserFeignClient {

    /**
     * 项目和用户关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelProjectUserListPageRequest request);

    /**
     * 添加项目和用户列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/user/list")
    Result addUserList(@Validated @RequestBody ApiRelProjectUserListAddRequest request);

    /**
     * 删除项目和用户关系
     * @param id 项目和用户关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "项目和用户关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前项目用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @PostMapping("/select/user/page")
    Result selectUserPage(@Validated @RequestBody ApiRelProjectUserSelectPageRequest request);

}
