package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelRoleMenuService;
import com.yd.user.feign.request.relrolemenu.ApiProjectRoleMenuListAddRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedProjectRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiSelectedTenantRoleMenuListRequest;
import com.yd.user.feign.request.relrolemenu.ApiTenantRoleMenuListAddRequest;
import com.yd.user.service.dto.RelRoleMenuDto;
import com.yd.user.service.model.RelRoleMenu;
import com.yd.user.service.model.RelTenantMenu;
import com.yd.user.service.service.IRelRoleMenuService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelRoleMenuServiceImpl implements ApiRelRoleMenuService {

    @Autowired
    private IRelRoleMenuService iRelRoleMenuService;

    /**
     * 租户管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantRoleMenuList(ApiTenantRoleMenuListAddRequest request) {
        //先删后增加
        //删除租户角色菜单关系
        iRelRoleMenuService.removeByTenant(request.getTenantBizId(),request.getRoleBizId());

        //增加租户角色菜单关系
        if (!CollectionUtils.isEmpty(request.getMenuBizIdList())) {
            //菜单唯一标识(业务ID) 列表（选中列表）不为空
            List<RelRoleMenu> list = request.getMenuBizIdList().stream().map(bizId -> {
                RelRoleMenu relRoleMenu = new RelRoleMenu();
                relRoleMenu.setTenantBizId(request.getTenantBizId());
                relRoleMenu.setRoleBizId(request.getRoleBizId());
                relRoleMenu.setMenuBizId(bizId);
                return relRoleMenu;
            }).collect(Collectors.toList());

            iRelRoleMenuService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 租户管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @Override
    public Result<List<String>> selectedTenantRoleMenuList(ApiSelectedTenantRoleMenuListRequest request) {
        List<RelRoleMenu> list = iRelRoleMenuService.queryList(RelRoleMenuDto.builder()
                .tenantBizId(request.getTenantBizId())
                .roleBizId(request.getRoleBizId())
                .build());
        List<String> menuList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            menuList = list.stream().map(RelRoleMenu::getMenuBizId).collect(Collectors.toList());
        }
        return Result.success(menuList);
    }

    /**
     * 项目管理-角色配置-分配菜单-添加菜单角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectRoleMenuList(ApiProjectRoleMenuListAddRequest request) {
        //先删后增加
        //删除项目角色菜单关系
        iRelRoleMenuService.removeByProject(request.getProjectBizId(),request.getRoleBizId());

        //增加项目角色菜单关系
        if (!CollectionUtils.isEmpty(request.getMenuBizIdList())) {
            //菜单唯一标识(业务ID) 列表（选中列表）不为空
            List<RelRoleMenu> list = request.getMenuBizIdList().stream().map(bizId -> {
                RelRoleMenu relRoleMenu = new RelRoleMenu();
                relRoleMenu.setProjectBizId(request.getProjectBizId());
                relRoleMenu.setRoleBizId(request.getRoleBizId());
                relRoleMenu.setMenuBizId(bizId);
                return relRoleMenu;
            }).collect(Collectors.toList());

            iRelRoleMenuService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 项目管理-角色配置-分配菜单-查询选中的菜单列表
     * @return
     */
    @Override
    public Result<List<String>> selectedProjectRoleMenuList(ApiSelectedProjectRoleMenuListRequest request) {
        List<RelRoleMenu> list = iRelRoleMenuService.queryList(RelRoleMenuDto.builder()
                .projectBizId(request.getProjectBizId())
                .roleBizId(request.getRoleBizId())
                .build());
        List<String> menuList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            menuList = list.stream().map(RelRoleMenu::getMenuBizId).collect(Collectors.toList());
        }
        return Result.success(menuList);
    }
}
