package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelProjectUserService;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListAddRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserListPageRequest;
import com.yd.user.feign.request.relprojectuser.ApiRelProjectUserSelectPageRequest;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserListPageResponse;
import com.yd.user.feign.response.relprojectuser.ApiRelProjectUserSelectPageResponse;
import com.yd.user.service.model.RelProjectUser;
import com.yd.user.service.service.IRelProjectUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelProjectUserServiceImpl implements ApiRelProjectUserService {

    @Autowired
    private IRelProjectUserService iRelProjectUserService;

    /**
     * 项目和用户关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectUserListPageResponse>> page(ApiRelProjectUserListPageRequest request) {
        Page<ApiRelProjectUserListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectUserListPageResponse> iPage = iRelProjectUserService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加项目和用户列表关系
     * @param request
     * @return
     */
    @Override
    public Result addUserList(ApiRelProjectUserListAddRequest request) {
        List<RelProjectUser> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(request.getUserBizIdList())) {
            //用户唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getUserBizIdList().stream().map(bizId -> {
                RelProjectUser relTenantUser = new RelProjectUser();
                relTenantUser.setProjectBizId(request.getProjectBizId());
                relTenantUser.setUserBizId(bizId);
                return relTenantUser;
            }).collect(Collectors.toList());

            iRelProjectUserService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除项目和用户关系
     * @param id 项目和用户关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelProjectUser relProjectUser = iRelProjectUserService.queryOne(id);
        if (Objects.isNull(relProjectUser)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelProjectUserService.removeById(relProjectUser.getId());
        return Result.success();
    }

    /**
     * 导入-选择用户分页查询（查询用户库的用户id不在当前项目用户关系的用户id列表中的数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelProjectUserSelectPageResponse>> selectUserPage(ApiRelProjectUserSelectPageRequest request) {
        Page<ApiRelProjectUserSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelProjectUserSelectPageResponse> iPage = iRelProjectUserService.selectUserPage(page, request);
        return Result.success(iPage);
    }
}
