package com.yd.user.api.dto;

import lombok.Data;


/**
 * 项目添加和编辑校验入参的DTO
 */
@Data
public class ApiSysProjectAddAndEditReqCheckDto {

    /**
     * 作用域(1:系统级（全局） 2:租户级 )
     */
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 是否内置项目（0-否 1-是 默认0-否 是内置项目，那么整个项目的所绑定的菜单权限都在中台系统展示内嵌外链iframe, 如果不是直接是访问项目卡片直接跳转到独立的前端项目链接获取权限菜单访问）
     */
    private Integer isIn;

    /**
     * 项目访问地址
     */
    private String projectUrl;

    /**
     * 是否超级管理员
     */
    private Boolean isAdmin;
}
