package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantProjectService;
import com.yd.user.feign.client.reltenantproject.ApiRelTenantProjectFeignClient;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListAddRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 租户-项目关系信息（租户管理-项目配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantProject")
@Validated
public class ApiRelTenantProjectController implements ApiRelTenantProjectFeignClient {

    @Autowired
    private ApiRelTenantProjectService apiRelTenantProjectService;

    /**
     * 租户和项目关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantProjectListPageResponse>> page(ApiRelTenantProjectListPageRequest request) {
        return apiRelTenantProjectService.page(request);
    }

    /**
     * 添加租户和项目列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectList(ApiRelTenantProjectListAddRequest request) {
        return apiRelTenantProjectService.addProjectList(request);
    }

    /**
     * 删除租户和项目关系
     * @param id 租户和项目关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantProjectService.del(id);
    }

    /**
     * 导入-选择项目分页查询（查询当前租户级（当前所属租户绑定的项目）或者系统级（全局项目在任何地方都适用导入绑定）的项目表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantProjectSelectPageResponse>> selectProjectPage(ApiRelTenantProjectSelectPageRequest request) {
        return apiRelTenantProjectService.selectProjectPage(request);
    }
}
