package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.dao.SysUserMapper;
import com.yd.user.service.service.ISysUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 系统用户表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class SysUserServiceImpl extends ServiceImpl<SysUserMapper, SysUser> implements ISysUserService {

    @Override
    public IPage<ApiSysUserPageResponse> page(Page<ApiSysUserPageResponse> page, ApiSysUserPageRequest request) {
        return baseMapper.page(page,request);
    }

    @Override
    public SysUser queryOne(String userUid) {
        return this.getOne(new LambdaQueryWrapper<SysUser>().eq(SysUser::getUserUid,userUid));
    }
}
