package com.yd.user.feign.request.systenant;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 添加租户-入参
 */
@Data
public class ApiSysTenantAddRequest {

    /**
     * 租户名称
     */
    @NotBlank(message = "租户名称不能为空")
    private String tenantName;

    /**
     * 租户LOGO
     */
    private String logoUrl;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 联系邮箱
     */
    private String contactEmail;

    /**
     * 所属行业
     */
    private String industry;

    /**
     * 联系地址
     */
    private String address;

    /**
     * 状态(0:禁用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 服务到期时间
     */
    private LocalDateTime expireTime;

    /**
     * 最大项目数
     */
    private Integer maxProject;

    /**
     * 最大用户数
     */
    private Integer maxUser;

}
