package com.yd.user.feign.fallback.sysproject;

import com.yd.common.result.Result;
import com.yd.user.feign.client.sysproject.ApiSysProjectFeignClient;
import com.yd.user.feign.request.sysproject.ApiSysProjectAddRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectEditRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectPageRequest;
import com.yd.user.feign.response.sysproject.ApiSysProjectDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务-系统项目信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysProjectFeignFallbackFactory implements FallbackFactory<ApiSysProjectFeignClient> {
    @Override
    public ApiSysProjectFeignClient create(Throwable cause) {
        return new ApiSysProjectFeignClient() {
            @Override
            public Result page(ApiSysProjectPageRequest request) {
                return null;
            }

            @Override
            public Result<ApiSysProjectDetailResponse> detail(String projectUid) {
                return null;
            }

            @Override
            public Result add(ApiSysProjectAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSysProjectEditRequest request) {
                return null;
            }

            @Override
            public Result del(String projectUid) {
                return null;
            }

            @Override
            public Result editStatus(String projectUid, Integer status) {
                return null;
            }
        };
    }
}
