/*
 * Decompiled with CFR 0.152.
 */
package com.yd.user.service.api.controller;

import com.yd.common.result.Result;
import com.yd.user.service.entity.User;
import com.yd.user.service.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Autowired
    private UserService userService;

    @GetMapping(value={"/{username}"})
    public Result<User> getUserByUsername(@PathVariable String username) {
        try {
            User user = this.userService.findByUsername(username);
            return Result.success((Object)user);
        }
        catch (Exception e) {
            return Result.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/register"})
    public Result<User> registerUser(@RequestBody User user) {
        try {
            User registeredUser = this.userService.register(user);
            return Result.success((Object)registeredUser);
        }
        catch (Exception e) {
            return Result.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/info"})
    public Result<User> getCurrentUserInfo() {
        try {
            User currentUser = this.userService.getCurrentUser();
            return Result.success((Object)currentUser);
        }
        catch (Exception e) {
            return Result.fail((String)e.getMessage());
        }
    }
}

