package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserListPageRequest;
import com.yd.user.feign.request.reltenantuser.ApiRelTenantUserSelectPageRequest;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserSelectPageResponse;
import com.yd.user.service.dto.RelTenantUserDto;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.model.RelTenantUser;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.user.service.model.SysMenu;

import java.util.List;

/**
 * <p>
 * 租户-用户关系表（多对多关系） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelTenantUserService extends IService<RelTenantUser> {

    IPage<ApiRelTenantUserListPageResponse> page(Page<ApiRelTenantUserListPageResponse> page,
                                                 ApiRelTenantUserListPageRequest request);

    IPage<ApiRelTenantUserSelectPageResponse> selectUserPage(Page<ApiRelTenantUserSelectPageResponse> page,
                                                             ApiRelTenantUserSelectPageRequest request);

    RelTenantUser queryOne(Long id);

    List<RelTenantUser> queryList(RelTenantUserDto dto);
}
