package com.yd.user.feign.client.reltenantproject;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantproject.ApiRelTenantProjectFeignFallbackFactory;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListAddRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 用户服务：租户-项目关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantProjectFeignFallbackFactory.class)
public interface ApiRelTenantProjectFeignClient {

    /**
     * 租户和项目关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelTenantProjectListPageRequest request);

    /**
     * 添加租户和项目列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/project/list")
    Result addProjectList(@Validated @RequestBody ApiRelTenantProjectListAddRequest request);

    /**
     * 删除租户和项目关系
     * @param id 租户和项目关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和项目关系表主键id不能为空") @RequestParam(value = "id") Long id);


    /**
     * 导入-选择项目分页查询（查询当前租户级（当前所属租户绑定的项目）或者系统级（全局项目在任何地方都适用导入绑定）的项目表数据）
     * @param request
     * @return
     */
    @PostMapping("/select/project/page")
    Result selectProjectPage(@RequestBody ApiRelTenantProjectSelectPageRequest request);
}
