package com.yd.user.feign.fallback.sysuser;

import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.feign.client.sysuser.ApiSysUserFeignClient;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务-系统用户信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysUserFeignFallbackFactory implements FallbackFactory<ApiSysUserFeignClient> {

    public ApiSysUserFeignClient create(final Throwable cause) {
        return new ApiSysUserFeignClient() {

            @Override
            public Result page(ApiSysUserPageRequest request) {
                log.error("分页查询失败: {}", cause.getMessage());
                throw new BusinessException("分页查询失败，请稍后重试");
            }

            @Override
            public Result add(ApiSysUserAddRequest request) {
                log.error("添加用户信息失败: {}", cause.getMessage());
                throw new BusinessException("添加用户信息失败，请稍后重试");
            }

            @Override
            public Result edit(ApiSysUserEditRequest request) {
                log.error("编辑用户信息失败: {}", cause.getMessage());
                throw new BusinessException("编辑用户信息失败，请稍后重试");
            }

            @Override
            public Result<ApiSysUserDetailResponse> detail(String userUid) {
                log.error("获取用户信息失败: {}", cause.getMessage());
                throw new BusinessException("获取用户信息失败，请稍后重试");
            }
        };
    }
}
