package com.yd.user.feign.fallback.sysrole;

import com.yd.common.result.Result;
import com.yd.user.feign.client.sysrole.ApiSysRoleFeignClient;
import com.yd.user.feign.request.sysrole.ApiSysRoleAddRequest;
import com.yd.user.feign.request.sysrole.ApiSysRoleEditRequest;
import com.yd.user.feign.request.sysrole.ApiSysRolePageRequest;
import com.yd.user.feign.response.sysrole.ApiSysRoleDetailResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 用户服务-系统角色信息Feign降级处理
 */
@Slf4j
@Component
public class ApiSysRoleFeignFallbackFactory implements FallbackFactory<ApiSysRoleFeignClient> {
    @Override
    public ApiSysRoleFeignClient create(Throwable cause) {
        return new ApiSysRoleFeignClient() {
            @Override
            public Result page(ApiSysRolePageRequest request) {
                return null;
            }

            @Override
            public Result<ApiSysRoleDetailResponse> detail(String roleUid) {
                return null;
            }

            @Override
            public Result add(ApiSysRoleAddRequest request) {
                return null;
            }

            @Override
            public Result edit(ApiSysRoleEditRequest request) {
                return null;
            }

            @Override
            public Result del(String roleUid) {
                return null;
            }

            @Override
            public Result editStatus(String roleUid, Integer status) {
                return null;
            }
        };
    }
}
