package com.yd.user.feign.client.sysproject;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysproject.ApiSysProjectFeignFallbackFactory;
import com.yd.user.feign.request.sysproject.ApiSysProjectAddRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectEditRequest;
import com.yd.user.feign.request.sysproject.ApiSysProjectPageRequest;
import com.yd.user.feign.response.sysproject.ApiSysProjectDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户服务-系统项目信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysProjectFeignFallbackFactory.class)
public interface ApiSysProjectFeignClient {

    /**
     * 项目分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysProjectPageRequest request);

    /**
     * 获取项目详情
     * @param projectUid 项目唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysProjectDetailResponse> detail(@RequestParam(value = "projectUid") String projectUid);

    /**
     * 添加项目
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@RequestBody ApiSysProjectAddRequest request);

    /**
     * 编辑项目
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@RequestBody ApiSysProjectEditRequest request);


    /**
     * 删除项目（逻辑删除）
     * @param projectUid 项目唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "projectUid") String projectUid);

    /**
     * 编辑项目状态
     * @param projectUid 项目唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @DeleteMapping("/edit/status")
    Result editStatus(@RequestParam(value = "projectUid") String projectUid,
                      @RequestParam(value = "status") Integer status);

}
