package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.auth.core.dto.AuthUserDto;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.dto.SysUserDto;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.model.SysUser;
import com.yd.user.service.dao.SysUserMapper;
import com.yd.user.service.service.ISysUserService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 系统用户表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class SysUserServiceImpl extends ServiceImpl<SysUserMapper, SysUser> implements ISysUserService {

    @Override
    public IPage<ApiSysUserPageResponse> page(Page<ApiSysUserPageResponse> page,
                                              ApiSysUserPageRequest request,
                                              Boolean isAdmin,
                                              String loginTenantBizId) {
        return baseMapper.page(page,request,isAdmin,loginTenantBizId);
    }

    @Override
    public SysUser queryOne(String userBizId) {
        return this.getOne(new LambdaQueryWrapper<SysUser>().eq(SysUser::getUserBizId,userBizId));
    }

    @Override
    public SysUser queryOneByName(String userName) {
        return this.getOne(new LambdaQueryWrapper<SysUser>().eq(SysUser::getUserName,userName));
    }

    /**
     * 根据条件查询用户列表信息
     * @param dto
     * @return
     */
    @Override
    public List<SysUser> queryList(SysUserDto dto) {
        List<SysUser> list = baseMapper.selectList(new LambdaQueryWrapper<SysUser>()
                .eq(!Objects.isNull(dto.getId()),SysUser::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getUserBizId()) && !dto.getIsExcludeMy(),SysUser::getUserBizId,dto.getUserBizId())
                .eq(StringUtils.isNotBlank(dto.getUserName()),SysUser::getUserName,dto.getUserName())
                .eq(StringUtils.isNotBlank(dto.getEmail()),SysUser::getEmail,dto.getEmail())
                .eq(StringUtils.isNotBlank(dto.getMobile()),SysUser::getMobile,dto.getMobile())
                .eq(!Objects.isNull(dto.getStatus()),SysUser::getStatus,dto.getStatus())
                .eq(!Objects.isNull(dto.getIsSuperAdmin()),SysUser::getIsSuperAdmin,dto.getIsSuperAdmin())
                .ne(dto.getIsExcludeMy(),SysUser::getUserBizId,dto.getUserBizId())
        );
        return list;
    }

}
