package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantPageResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.dto.SysTenantDto;
import com.yd.user.service.model.SysTenant;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 租户信息表 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface ISysTenantService extends IService<SysTenant> {

    IPage<ApiSysTenantPageResponse> page(Page<ApiSysTenantPageResponse> page,
                                         ApiSysTenantPageRequest request,
                                         Boolean isAdmin,
                                         String userBizId,
                                         String loginTenantBizId);

    SysTenant queryOne(String tenantBizId);

    List<SysTenant> queryList(SysTenantDto dto);
}
