package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 租户公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysTenantDto {

    /**
     * 租户ID
     */
    private Long id;

    /**
     * 租户唯一标识(业务ID)
     */
    private String tenantBizId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 查询是否排除当前租户唯一标识数据，默认false不排除，true的话tenantBizId必传
     */
    private Boolean isExcludeMy = false;
}
