package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 菜单公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysMenuDto {

    private Long id;

    /**
     * 菜单唯一标识(业务ID)
     */
    private String menuBizId;

    /**
     * 父菜单ID
     */
    private String parentBizId;

    /**
     * 菜单名称
     */
    private String menuName;

    /**
     * 查询是否排除当前菜单唯一标识数据，默认false不排除，true的话projectBizId必传
     */
    private Boolean isExcludeMy = false;
}
