package com.yd.user.feign.response.sysuser;

import lombok.Data;

import java.time.LocalDateTime;

@Data
public class ApiSysUserPageResponse {

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 用户唯一标识(业务ID)
     */
    private String userBizId;

    /**
     * 登录账号
     */
    private String userName;

    /**
     * 真实姓名
     */
    private String realName;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    private Integer gender;

    /**
     * 状态(0:禁用 1:正常 2:锁定)
     */
    private Integer status;

    /**
     * 是否超级管理员(0:否 1:是)
     */
    private Integer isSuperAdmin;

    /**
     * 最后登录IP
     */
    private String lastLoginIp;

    /**
     * 最后登录时间
     */
    private LocalDateTime lastLoginTime;

    /**
     * 最后修改密码时间
     */
    private LocalDateTime lastPasswordTime;

    /**
     * 用户来源(1:系统创建...)
     */
    private Integer sourceType;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

}
