package com.yd.user.feign.request.sysrole;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 添加角色-入参
 */
@Data
public class ApiSysRoleAddRequest {

    /**
     * 角色名称
     */
    @NotBlank(message = "角色名称不能为空")
    private String roleName;

    /**
     * 角色权限字符串（用于安全认证访问控制）
     */
    private String roleKey;

    /**
     * 角色类型(1:超级管理员 2:管理员 3:普通用户)
     */
    private Integer roleType;

    /**
     * 描述
     */
    private String description;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

}
