package com.yd.user.feign.request.sysproject;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 编辑项目-入参
 */
@Data
public class ApiSysProjectEditRequest {

    /**
     * 项目主键id
     */
    @NotNull(message = "项目主键id不能为空")
    private Long id;

    /**
     * 项目唯一标识(业务ID)
     */
    @NotBlank(message = "项目唯一标识(业务ID)不能为空")
    private String projectBizId;

    /**
     * 项目名称
     */
    @NotBlank(message = "项目名称不能为空")
    private String projectName;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 状态(0:禁用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 项目开始时间
     */
    private LocalDateTime startTime;

    /**
     * 项目结束时间
     */
    private LocalDateTime endTime;

    /**
     * 作用域(1:系统级（全局） 2:租户级 )
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;
}
