package com.yd.user.feign.client.sysuser;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysuser.ApiSysUserFeignFallbackFactory;
import com.yd.user.feign.request.sysuser.ApiSysUserAddRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditPwdRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserEditRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.sysuser.ApiSysUserDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 用户服务-系统用户信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysUserFeignFallbackFactory.class)
public interface ApiSysUserFeignClient {

    /**
     * 用户分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysUserPageRequest request);

    /**
     * 添加用户
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@Validated @RequestBody ApiSysUserAddRequest request);

    /**
     * 编辑用户
     * @param request
     * @return
     */
    @PutMapping("/edit")
    Result edit(@Validated @RequestBody ApiSysUserEditRequest request);

    /**
     * 获取用户详情
     * @param userBizId 用户业务唯一标识id
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysUserDetailResponse> detail(@NotBlank(message = "用户业务唯一标识id不能为空") @RequestParam(value = "userBizId") String userBizId);

    /**
     * 编辑用户状态
     * @param userBizId
     * @param status
     * @return
     */
    @PatchMapping("/edit/status")
    Result editStatus(@NotBlank(message = "用户唯一标识(业务ID)不能为空") @RequestParam(value = "userBizId") String userBizId,
                      @NotNull(message = "状态不能为空") @RequestParam(value = "status") Integer status);

    /**
     * 编辑用户密码
     * @return
     */
    @PostMapping("/edit/pwd")
    Result editPwd(@Validated @RequestBody ApiSysUserEditPwdRequest request);
}
