package com.yd.user.feign.client.reluserrole;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reluserrole.ApiRelUserRoleFeignFallbackFactory;
import com.yd.user.feign.request.reluserrole.ApiProjectUserRoleListAddRequest;
import com.yd.user.feign.request.reluserrole.ApiTenantUserRoleListAddRequest;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户服务：用户-角色关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelUserRoleFeignFallbackFactory.class)
public interface ApiRelUserRoleFeignClient {

    /**
     * 租户管理-用户配置-权限配置-添加用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/tenant/userRoleList")
    Result addTenantUserRoleList(@Validated @RequestBody ApiTenantUserRoleListAddRequest request);

    /**
     * 租户管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @GetMapping("/selected/tenant/userRoleList")
    Result<List<ApiSelectedTenantUserRoleListResponse>> selectedTenantUserRoleList(@NotBlank(message = "租户唯一标识(业务ID)不能为空") @RequestParam(value = "tenantBizId") String tenantBizId,
                                                                                   @NotBlank(message = "用户ID（业务id）不能为空") @RequestParam(value = "userBizId") String userBizId);

    /**
     * 项目管理-用户配置-权限配置-添加用户角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/project/userRoleList")
    Result addProjectUserRoleList(@Validated @RequestBody ApiProjectUserRoleListAddRequest request);

    /**
     * 项目管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @GetMapping("/selected/project/userRoleList")
    Result<List<ApiSelectedProjectUserRoleListResponse>> selectedProjectUserRoleList(@NotBlank(message = "项目唯一标识(业务ID)不能为空") @RequestParam(value = "projectBizId") String projectBizId,
                                                                                     @NotBlank(message = "用户ID（业务id）不能为空") @RequestParam(value = "userBizId") String userBizId);
}
