package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.service.ApiSysTenantService;
import com.yd.user.feign.request.systenant.ApiSysTenantAddRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantEditRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantDetailResponse;
import com.yd.user.feign.response.systenant.ApiSysTenantPageResponse;
import com.yd.user.service.dto.SysTenantDto;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.service.ISysTenantService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

@Service
public class ApiSysTenantServiceImpl implements ApiSysTenantService {

    @Autowired
    private ISysTenantService iSysTenantService;

    /**
     * 租户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysTenantPageResponse>> page(ApiSysTenantPageRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        //TODO 获取当前登录用户id
        String userBizId = "";
        //TODO 当前登录人所属租户id
        String loginTenantBizId = "";
        Page<ApiSysTenantPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSysTenantPageResponse> iPage = iSysTenantService.page(page, request,isAdmin,userBizId,loginTenantBizId);
        return Result.success(iPage);
    }

    /**
     * 获取租户详情
     * @param tenantBizId 租户唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysTenantDetailResponse> detail(String tenantBizId) {
        SysTenant sysTenant = iSysTenantService.queryOne(tenantBizId);
        ApiSysTenantDetailResponse response = null;
        if (!Objects.isNull(sysTenant)) {
            response = new ApiSysTenantDetailResponse();
            BeanUtils.copyProperties(sysTenant,response);
        }
        return Result.success(response);
    }

    /**
     * 添加租户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysTenantAddRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        if (!isAdmin) {
            //非超级管理员不能添加租户
            throw new BusinessException("非超级管理员不能添加租户！");
        }
        List<SysTenant> list = iSysTenantService.queryList(SysTenantDto.builder()
                .tenantName(request.getTenantName())
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            //租户名称已存在
            throw new BusinessException(ResultCode.TENANT_NAME_EXISTS.getCode(),ResultCode.TENANT_NAME_EXISTS.getMessage());
        }
        //新增
        SysTenant sysTenant = new SysTenant();
        BeanUtils.copyProperties(request,sysTenant);
        sysTenant.setTenantBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_TENANT.getCode()));
        iSysTenantService.saveOrUpdate(sysTenant);
        return Result.success();
    }

    /**
     * 编辑租户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysTenantEditRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;

        //校验租户是否存在
        checkSysTenantIsExist(request.getTenantBizId());

        //校验租户名称的唯一性
        List<SysTenant> list = iSysTenantService.queryList(SysTenantDto.builder()
                .tenantName(request.getTenantName())
                .tenantBizId(request.getTenantBizId())
                .isExcludeMy(true)
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            //租户名称已存在
            throw new BusinessException(ResultCode.TENANT_NAME_EXISTS.getCode(),ResultCode.TENANT_NAME_EXISTS.getMessage());
        }
        //编辑
        SysTenant sysTenant = new SysTenant();
        BeanUtils.copyProperties(request,sysTenant);
        sysTenant.setTenantBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_TENANT.getCode()));
        iSysTenantService.saveOrUpdate(sysTenant);
        return Result.success();
    }

    /**
     * 编辑租户状态
     * @param tenantBizId 租户唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String tenantBizId, Integer status) {
        //校验租户是否存在
        Result<SysTenant> result = checkSysTenantIsExist(tenantBizId);

        SysTenant sysTenant = result.getData();
        sysTenant.setStatus(status);
        iSysTenantService.saveOrUpdate(sysTenant);
        return Result.success();
    }

    /**
     * 校验租户是否存在
     * @param tenantBizId
     * @return
     */
    public Result<SysTenant> checkSysTenantIsExist(String tenantBizId) {
        SysTenant sysTenant = iSysTenantService.queryOne(tenantBizId);
        if (Objects.isNull(sysTenant)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        return Result.success(sysTenant);
    }
}
