package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantRoleService;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListAddRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelTenantProject;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.service.IRelTenantRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
public class ApiRelTenantRoleServiceImpl implements ApiRelTenantRoleService {

    @Autowired
    private IRelTenantRoleService iRelTenantRoleService;

    /**
     * 租户和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantRoleListPageResponse>> page(ApiRelTenantRoleListPageRequest request) {
        Page<ApiRelTenantRoleListPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantRoleListPageResponse> iPage = iRelTenantRoleService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加租户和角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRoleList(ApiRelTenantRoleListAddRequest request) {
        List<RelTenantRole> list = new ArrayList<>();
        if (CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            //角色唯一标识(业务ID) 列表（选中列表）不为空
            list = request.getRoleBizIdList().stream().map(bizId -> {
                RelTenantRole relTenantRole = new RelTenantRole();
                relTenantRole.setTenantBizId(request.getTenantBizId());
                relTenantRole.setRoleBizId(bizId);
                return relTenantRole;
            }).collect(Collectors.toList());

            iRelTenantRoleService.saveOrUpdateBatch(list);
        }

        return Result.success();
    }

    /**
     * 删除租户和角色关系
     * @param id 租户和角色关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        RelTenantRole relTenantRole = iRelTenantRoleService.queryOne(id);
        if (Objects.isNull(relTenantRole)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        iRelTenantRoleService.removeById(relTenantRole.getId());
        return Result.success();
    }

    /**
     * 导入-选择角色分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantRoleSelectPageResponse>> selectRolePage(ApiRelTenantRoleSelectPageRequest request) {
        Page<ApiRelTenantRoleSelectPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiRelTenantRoleSelectPageResponse> iPage = iRelTenantRoleService.selectProjectPage(page, request);
        return Result.success(iPage);
    }

    /**
     * 添加-单个租户和项目关系
     * @param tenantBizId
     * @param roleBizId
     * @return
     */
    @Override
    public Result addSingleRel(String tenantBizId, String roleBizId) {
        //新增关系
        RelTenantRole relTenantRole = new RelTenantRole();
        relTenantRole.setTenantBizId(tenantBizId);
        relTenantRole.setRoleBizId(roleBizId);
        iRelTenantRoleService.saveOrUpdate(relTenantRole);
        return Result.success();
    }
}
