package com.yd.user.api.controller;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelUserRoleService;
import com.yd.user.feign.client.reluserrole.ApiRelUserRoleFeignClient;
import com.yd.user.feign.request.reluserrole.ApiProjectUserRoleListAddRequest;
import com.yd.user.feign.request.reluserrole.ApiTenantUserRoleListAddRequest;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户-角色关系信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relUserRole")
@Validated
public class ApiRelUserRoleController implements ApiRelUserRoleFeignClient {

    @Autowired
    private ApiRelUserRoleService apiRelUserRoleService;

    /**
     * 租户管理-用户配置-权限配置-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request) {
        return apiRelUserRoleService.addTenantUserRoleList(request);
    }

    /**
     * 租户管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public Result<List<ApiSelectedTenantUserRoleListResponse>> selectedTenantUserRoleList(String tenantBizId, String userBizId) {
        return apiRelUserRoleService.selectedTenantUserRoleList(tenantBizId,userBizId);
    }

    /**
     * 项目管理-用户配置-权限配置-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request) {
        return apiRelUserRoleService.addProjectUserRoleList(request);
    }

    /**
     * 项目管理-用户配置-权限配置-查询选中的角色列表
     * @return
     */
    @Override
    public Result<List<ApiSelectedProjectUserRoleListResponse>> selectedProjectUserRoleList(String projectBizId, String userBizId) {
        return apiRelUserRoleService.selectedProjectUserRoleList(projectBizId,userBizId);
    }
}
