package com.yd.user.api.service.impl;

import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantRoleService;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.service.IRelTenantRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RelTenantRoleServiceImpl implements ApiRelTenantRoleService {

    @Autowired
    private IRelTenantRoleService iRelTenantRoleService;

    /**
     * 添加-单个租户和项目关系
     * @param tenantBizId
     * @param roleBizId
     * @return
     */
    @Override
    public Result addSingleRel(String tenantBizId, String roleBizId) {
        //新增关系
        RelTenantRole relTenantRole = new RelTenantRole();
        relTenantRole.setTenantBizId(tenantBizId);
        relTenantRole.setRoleBizId(roleBizId);
        iRelTenantRoleService.saveOrUpdate(relTenantRole);
        return Result.success();
    }
}
