package com.yd.user.feign.fallback.projectmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.client.relprojectmenu.ApiRelProjectMenuFeignClient;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListAddRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuListPageRequest;
import com.yd.user.feign.request.relprojectmenu.ApiRelProjectMenuTreeListRequest;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuImportQueryMenuTreeResponse;
import com.yd.user.feign.response.relprojectmenu.ApiRelProjectMenuTreeListResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 用户服务：项目-菜单关系信息Feign降级处理
 */
@Slf4j
@Component
public class ApiRelProjectMenuFeignFallbackFactory implements FallbackFactory<ApiRelProjectMenuFeignClient> {
    @Override
    public ApiRelProjectMenuFeignClient create(Throwable cause) {
        return new ApiRelProjectMenuFeignClient() {

            @Override
            public Result page(ApiRelProjectMenuListPageRequest request) {
                return null;
            }

            @Override
            public Result<List<ApiRelProjectMenuTreeListResponse>> tree(ApiRelProjectMenuTreeListRequest request) {
                return null;
            }

            @Override
            public Result addMenuList(ApiRelProjectMenuListAddRequest request) {
                return null;
            }

            @Override
            public Result del(Long id) {
                return null;
            }

            @Override
            public Result<List<ApiRelProjectMenuImportQueryMenuTreeResponse>> importQueryMenuTree(ApiRelProjectMenuImportQueryMenuTreeRequest request) {
                return null;
            }

            @Override
            public Result<List<String>> selectedList(String projectBizId) {
                return null;
            }
        };
    }
}
