package com.yd.user.feign.request.clientuser;

import com.yd.common.dto.PageDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class ApiClientUserPageRequest extends PageDto {

    /**
     * 查询内容（姓名/手机号/邮箱，支持模糊搜索）
     */
    @Schema(description = "查询内容（姓名/手机号/邮箱，支持模糊搜索）")
    private String queryContent;

    /**
     * 所属租户唯一业务ID
     */
    @Schema(description = "所属租户唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String tenantBizId;
    /**
     * 所属项目唯一业务ID
     */
    @Schema(description = "所属项目唯一业务ID", requiredMode = Schema.RequiredMode.REQUIRED)
    private String projectBizId;

    /**
     * 用户唯一标识(sys_user系统用户表)
     */
    @Schema(description = "用户唯一标识(sys_user系统用户表)")
    private String userBizId;
}
