package com.yd.user.feign.client.sysdict;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysdict.ApiSysDictFeignFallbackFactory;
import com.yd.user.feign.request.sysdict.GetDictTypeListRequest;
import com.yd.user.feign.response.sysdict.GetDictItemListByDictTypeResponse;
import com.yd.user.feign.response.sysdict.GetDictTypeListResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 用户服务-字典类型信息信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysDictFeignFallbackFactory.class)
public interface ApiSysDictFeignClient {

    /**
     * 根据字典类型获取字典数据项列表
     * @param dictType
     * @return
     */
    @GetMapping("/type/item/list/{dictType}")
    Result<List<GetDictItemListByDictTypeResponse>> getDictItemListByDictType(@NotBlank(message = "字典类型不能为空") @PathVariable("dictType") String dictType);

    /**
     * 根据字典类型列表获取字典数据项列表
     * @return
     */
    @PostMapping("/type/list")
    Result<List<GetDictTypeListResponse>> getByDictTypeList(@Validated @RequestBody GetDictTypeListRequest request);
}
