package com.yd.user.service.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 系统用户表
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Getter
@Setter
@ToString
@TableName("sys_user")
public class SysUser implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户唯一标识(业务ID)
     */
    @TableField("user_biz_id")
    private String userBizId;

    /**
     * 登录账号
     */
    @TableField("user_name")
    private String userName;

    /**
     * 加密密码
     */
    @TableField("password")
    private String password;

    /**
     * 密码盐值
     */
    @TableField("password_salt")
    private String passwordSalt;

    /**
     * 真实姓名
     */
    @TableField("real_name")
    private String realName;

    /**
     * 昵称
     */
    @TableField("nick_name")
    private String nickName;

    /**
     * 头像URL
     */
    @TableField("avatar")
    private String avatar;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 手机号
     */
    @TableField("mobile")
    private String mobile;

    /**
     * 性别(0:未知 1:男 2:女)
     */
    @TableField("gender")
    private Integer gender;

    /**
     * 状态(0:禁用 1:正常 2:锁定)
     */
    @TableField("status")
    private Integer status;

    /**
     * 是否超级管理员(0:否 1:是)
     */
    @TableField("is_super_admin")
    private Integer isSuperAdmin;

    /**
     * 最后登录IP
     */
    @TableField("last_login_ip")
    private String lastLoginIp;

    /**
     * 最后登录时间
     */
    @TableField("last_login_time")
    private LocalDateTime lastLoginTime;

    /**
     * 最后修改密码时间
     */
    @TableField("last_password_time")
    private LocalDateTime lastPasswordTime;

    /**
     * 用户来源(1:系统创建...)
     */
    @TableField("source_type")
    private Integer sourceType;

    /**
     * 用户属性(1-业务员（销售） 2-签单员)
     */
    @TableField("attribute")
    private Integer attribute;

    /**
     * 通用备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    @TableField("is_deleted")
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    @TableField("creator_id")
    private String creatorId;

    /**
     * 更新人ID
     */
    @TableField("updater_id")
    private String updaterId;

    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private LocalDateTime updateTime;
}
