package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiClientUserService;
import com.yd.user.feign.client.clientuser.ApiClientUserFeignClient;
import com.yd.user.feign.request.clientuser.ApiClientUserDetailBodyRequest;
import com.yd.user.feign.request.clientuser.ApiClientUserPageRequest;
import com.yd.user.feign.response.clientuser.ApiClientUserDetailResponse;
import com.yd.user.feign.response.clientuser.ApiClientUserPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

/**
 * 客户端用户信息
 *
 * @author zxm
 * @since 2025-10-20
 */
@RestController
@RequestMapping("/clientUser")
@Validated
public class ApiClientUserController implements ApiClientUserFeignClient {

    @Autowired
    private ApiClientUserService apiClientUserService;

    /**
     * 分页查询-客户端用户信息
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiClientUserPageResponse>> page(ApiClientUserPageRequest request) {
        return apiClientUserService.page(request);
    }

    /**
     * 详情-客户端用户信息
     * @param clientUserBizId
     * @return
     */
    @Override
    public Result<ApiClientUserDetailResponse> detail(String clientUserBizId) {
        return apiClientUserService.detail(clientUserBizId);
    }

    /**
     * 获取客户端用户详情 body入参
     * @return
     */
    @Override
    public Result<ApiClientUserDetailResponse> detail(ApiClientUserDetailBodyRequest request) {
        return apiClientUserService.detail(request);
    }

}
