package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.dao.RelTenantRoleMapper;
import com.yd.user.service.service.IRelTenantRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 租户-角色关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class RelTenantRoleServiceImpl extends ServiceImpl<RelTenantRoleMapper, RelTenantRole> implements IRelTenantRoleService {

    /**
     * 租户和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantRoleListPageResponse> page(Page<ApiRelTenantRoleListPageResponse> page, ApiRelTenantRoleListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantRole queryOne(Long id) {
        return this.getOne(new LambdaQueryWrapper<RelTenantRole>().eq(RelTenantRole::getId,id));
    }

    /**
     * 导入-选择角色分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantRoleSelectPageResponse> selectProjectPage(Page<ApiRelTenantRoleSelectPageResponse> page,
                                                                       ApiRelTenantRoleSelectPageRequest request) {
        return baseMapper.selectProjectPage(page,request);
    }
}
