package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuSelectPageResponse;
import com.yd.user.service.model.RelTenantMenu;
import com.yd.user.service.dao.RelTenantMenuMapper;
import com.yd.user.service.service.IRelTenantMenuService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 租户-菜单关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class RelTenantMenuServiceImpl extends ServiceImpl<RelTenantMenuMapper, RelTenantMenu> implements IRelTenantMenuService {

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantMenuListPageResponse> page(Page<ApiRelTenantMenuListPageResponse> page,
                                                        ApiRelTenantMenuListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 导入-选择菜单分页查询（查询当前租户级（当前所属租户绑定的菜单）或者系统级（全局菜单在任何地方都适用导入绑定）的菜单表数据）
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantMenuSelectPageResponse> selectProjectPage(Page<ApiRelTenantMenuSelectPageResponse> page,
                                                                       ApiRelTenantMenuSelectPageRequest request) {
        return baseMapper.selectProjectPage(page,request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantMenu queryOne(Long id) {
        return this.getById(id);
    }
}
