package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRoleListResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRoleListResponse;
import com.yd.user.service.model.RelUserRole;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 用户-角色关系表（多对多关系） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelUserRoleMapper extends BaseMapper<RelUserRole> {

    List<ApiSelectedTenantUserRoleListResponse> selectedTenantUserRoleList(@Param("tenantBizId") String tenantBizId,
                                                                           @Param("userBizId") String userBizId);

    List<ApiSelectedProjectUserRoleListResponse> selectedProjectUserRoleList(@Param("projectBizId") String projectBizId,
                                                                             @Param("userBizId") String userBizId);
}
