package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuListPageResponse;
import com.yd.user.feign.response.reltenantmenu.ApiRelTenantMenuSelectPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelTenantMenu;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 租户-菜单关系表（正常来说一对多，加关系表方便扩展） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelTenantMenuMapper extends BaseMapper<RelTenantMenu> {

    IPage<ApiRelTenantMenuListPageResponse> page(@Param("page") IPage<ApiRelTenantMenuListPageResponse> page,
                                                 @Param("request") ApiRelTenantMenuListPageRequest request);


    IPage<ApiRelTenantMenuSelectPageResponse> selectProjectPage(@Param("page") IPage<ApiRelTenantMenuSelectPageResponse> page,
                                                                @Param("request") ApiRelTenantMenuSelectPageRequest request);
}
