package com.yd.user.feign.response.sysproject;

import lombok.Data;

import java.time.LocalDateTime;

/**
 * 获取项目详情-出参
 */
@Data
public class ApiSysProjectDetailResponse {
    /**
     * 项目ID
     */
    private Long id;

    /**
     * 项目唯一标识(业务ID)
     */
    private String projectBizId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目编码(租户内唯一)
     */
    private String projectCode;

    /**
     * 项目描述
     */
    private String description;

    /**
     * 状态(0:禁用 1:启用)
     */
    private Integer status;

    /**
     * 项目开始时间
     */
    private LocalDateTime startTime;

    /**
     * 项目结束时间
     */
    private LocalDateTime endTime;

    /**
     * 所属租户ID（业务id） 数据范围：1-私有
     */
    private String tenantBizId;

    /**
     * 所属租户名称 数据范围：1-私有
     */
    private String tenantName;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Boolean isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;
}
