package com.yd.user.feign.request.sysmenu;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 编辑菜单入参
 */
@Data
public class ApiSysMenuEditRequest {

    /**
     * 菜单表主键id
     */
    @NotNull(message = "菜单表主键id不能为空")
    private Long id;

    /**
     * 菜单唯一标识(业务ID)
     */
    @NotBlank(message = "菜单唯一标识(业务ID)不能为空")
    private String menuBizId;

    /**
     * 父菜单ID
     */
    @NotNull(message = "父菜单ID不能为空")
    private String parentBizId;

    /**
     * 菜单名称
     */
    @NotBlank(message = "菜单名称不能为空")
    private String menuName;

    /**
     * 类型(1:目录 2:菜单 3:按钮)
     */
    @NotNull(message = "类型不能为空")
    private Integer menuType;

    /**
     * 路由地址
     */
    private String path;

    /**
     * 组件路径
     */
    private String component;

    /**
     * 图标
     */
    private String icon;

    /**
     * 是否外链(0:否 1:是)
     */
    private Integer isExternal;

    /**
     * 是否缓存(0:否 1:是)
     */
    private Integer isCache;

    /**
     * 是否显示(0:隐藏 1:显示)
     */
    private Integer isVisible;

    /**
     * 权限标识(如:user:add)
     */
    private String permission;

    /**
     * 显示顺序
     */
    @NotNull(message = "显示顺序不能为空")
    private Integer orderNum;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;
}


