package com.yd.user.feign.client.reltenantmenu;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantmenu.ApiRelTenantMenuFeignFallbackFactory;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListAddRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuListPageRequest;
import com.yd.user.feign.request.reltenantmenu.ApiRelTenantMenuSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import javax.validation.constraints.NotNull;

/**
 * 用户服务：租户-菜单关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantMenuFeignFallbackFactory.class)
public interface ApiRelTenantMenuFeignClient {

    /**
     * 租户和菜单关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@Validated @RequestBody ApiRelTenantMenuListPageRequest request);

    /**
     * 添加租户和菜单列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/menu/list")
    Result addMenuList(@Validated @RequestBody ApiRelTenantMenuListAddRequest request);

    /**
     * 删除租户和菜单关系
     * @param id 租户和菜单关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和菜单关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择菜单分页查询（查询当前租户级（当前所属租户绑定的菜单）或者系统级（全局菜单在任何地方都适用导入绑定）的菜单表数据）
     * @param request
     * @return
     */
    @PostMapping("/select/menu/page")
    Result selectMenuPage(@Validated @RequestBody ApiRelTenantMenuSelectPageRequest request);
}
