package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.MenuTypeEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.dto.ApiSysMenuAddAndEditReqCheckDto;
import com.yd.user.api.service.ApiRelProjectMenuService;
import com.yd.user.api.service.ApiRelTenantMenuService;
import com.yd.user.api.service.ApiSysMenuService;
import com.yd.user.feign.request.sysmenu.ApiSysMenuAddRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuEditRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuPageRequest;
import com.yd.user.feign.request.sysmenu.ApiSysMenuTreeListRequest;
import com.yd.user.feign.response.sysmenu.ApiSysMenuDetailResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuPageResponse;
import com.yd.user.feign.response.sysmenu.ApiSysMenuTreeListResponse;
import com.yd.user.service.dto.SysMenuDto;
import com.yd.user.service.model.SysMenu;
import com.yd.user.service.service.ISysMenuService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.Objects;

@Service
public class ApiSysMenuServiceImpl implements ApiSysMenuService {

    @Autowired
    private ISysMenuService iSysMenuService;

    @Autowired
    private ApiRelTenantMenuService apiRelTenantMenuService;

    @Autowired
    private ApiRelProjectMenuService apiRelProjectMenuService;

    /**
     * 树形菜单列表查询
     * @param request
     * @return
     */
    @Override
    public Result<List<ApiSysMenuTreeListResponse>> treeList(ApiSysMenuTreeListRequest request) {
        return null;
    }

    /**
     * 菜单分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysMenuPageResponse>> page(ApiSysMenuPageRequest request) {
        return null;
    }

    /**
     * 获取菜单详情
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysMenuDetailResponse> detail(String menuBizId) {
        Result<SysMenu> result = checkSysMenuIsExist(menuBizId);
        SysMenu sysMenu = result.getData();

        ApiSysMenuDetailResponse response = new ApiSysMenuDetailResponse();
        BeanUtils.copyProperties(sysMenu,response);
        return Result.success(response);
    }

    /**
     * 添加菜单
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysMenuAddRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        ApiSysMenuAddAndEditReqCheckDto dto = new ApiSysMenuAddAndEditReqCheckDto();
        BeanUtils.copyProperties(request,dto);
        dto.setIsAdmin(isAdmin);
        dto.setOprSource(CommonEnum.OPR_SOURCE_ADD.getCode());
        //菜单添加和编辑校验入参的合理性（非查询库校验）
        addAndEditReqCheck(dto);

        //校验菜单名称唯一性
        List<SysMenu> list = iSysMenuService.queryList(SysMenuDto.builder()
                .menuName(request.getMenuName())
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            throw new BusinessException(ResultCode.MENU_NAME_EXISTS.getCode(),ResultCode.MENU_NAME_EXISTS.getMessage());
        }

        SysMenu sysMenu = new SysMenu();
        BeanUtils.copyProperties(request,sysMenu);
        sysMenu.setMenuBizId(RandomStringGenerator.generateBizId16(CommonEnum.UID_TYPE_MENU.getCode()));
        //添加和编辑保存设置参数公共方法
        sysMenu = addAndEditSaveSetCommon(sysMenu);
        iSysMenuService.saveOrUpdate(sysMenu);

        //新增或者编辑-更新租户菜单关系、更新项目菜单关系公共方法
        addAndEditByRelCommon(request.getTenantBizId(),
                request.getProjectBizId(),
                sysMenu.getMenuBizId(),
                request.getScope(),
                CommonEnum.OPR_SOURCE_ADD.getCode());

        return Result.success();
    }

    /**
     * 编辑菜单
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysMenuEditRequest request) {
        //TODO 当前登录用户的角色类型 true是超级管理员 false是超级管理员
        Boolean isAdmin = false;
        ApiSysMenuAddAndEditReqCheckDto dto = new ApiSysMenuAddAndEditReqCheckDto();
        BeanUtils.copyProperties(request,dto);
        dto.setIsAdmin(isAdmin);
        dto.setOprSource(CommonEnum.OPR_SOURCE_EDIT.getCode());
        //菜单添加和编辑校验入参的合理性（非查询库校验）
        addAndEditReqCheck(dto);

        //校验菜单是否存在
        Result<SysMenu> result = checkSysMenuIsExist(request.getMenuBizId());
        SysMenu sysMenu = result.getData();

        //校验菜单名称唯一性
        List<SysMenu> list = iSysMenuService.queryList(SysMenuDto.builder()
                .menuName(request.getMenuName())
                .menuBizId(request.getMenuBizId())
                .isExcludeMy(true)
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            throw new BusinessException(ResultCode.MENU_NAME_EXISTS.getCode(),ResultCode.MENU_NAME_EXISTS.getMessage());
        }

        BeanUtils.copyProperties(request,sysMenu);
        //添加和编辑保存设置参数公共方法
        sysMenu = addAndEditSaveSetCommon(sysMenu);
        iSysMenuService.saveOrUpdate(sysMenu);

        //新增或者编辑-更新租户菜单关系、更新项目菜单关系公共方法 TODO
//        addAndEditByRelCommon(request.getTenantBizId(),
//                request.getProjectBizId(),
//                sysMenu.getMenuBizId(),
//                request.getScope(),
//                CommonEnum.OPR_SOURCE_EDIT.getCode());

        return Result.success();
    }

    /**
     * 新增或者编辑-更新租户菜单关系、更新项目菜单关系公共方法
     * @param tenantBizId 租户id
     * @param projectBizId 项目id
     * @param menuBizId 菜单id
     * @param scope 作用域
     * @param oprSource 操作来源 1-添加 2-编辑
     */
    public void addAndEditByRelCommon(String tenantBizId,
                                      String projectBizId,
                                      String menuBizId,
                                      Integer scope,
                                      String oprSource) {
        if (CommonEnum.OPR_SOURCE_ADD.getCode().equals(oprSource)) {
            //添加来源
            if (CommonEnum.SCOPE_TENANT.getCode().equals(scope.toString())) {
                //作用域租户级-新增租户菜单关系
                apiRelTenantMenuService.addSingleRel(tenantBizId,menuBizId);
            }
            if (CommonEnum.SCOPE_PROJECT.getCode().equals(scope.toString())) {
                //作用域项目级-新增项目菜单关系
                apiRelProjectMenuService.addSingleRel(projectBizId,menuBizId);
            }
        }else if (CommonEnum.OPR_SOURCE_EDIT.getCode().equals(oprSource)) {
            //编辑来源 TODO
        }
    }

    /**
     * 添加和编辑保存设置参数公共方法
     * @param sysMenu
     * @return
     */
    public SysMenu addAndEditSaveSetCommon(SysMenu sysMenu) {
        if (CommonEnum.SCOPE_SYS.getCode().equals(sysMenu.getScope().toString())) {
            //系统级
            sysMenu.setTenantBizId("");
            sysMenu.setProjectBizId("");
        }else if (CommonEnum.SCOPE_TENANT.getCode().equals(sysMenu.getScope().toString())) {
            //租户级
            sysMenu.setProjectBizId("");
        }else if (CommonEnum.SCOPE_PROJECT.getCode().equals(sysMenu.getScope().toString())) {
            //项目级
            sysMenu.setTenantBizId("");
        }
        return sysMenu;
    }

    /**
     * 菜单添加和编辑校验入参的合理性（非查询库校验）
     * @param dto
     */
    public void addAndEditReqCheck(ApiSysMenuAddAndEditReqCheckDto dto) {
        if (MenuTypeEnum.ML.getCode().equals(dto.getMenuType().toString())
            && StringUtils.isBlank(dto.getPath())) {
            //菜单类型为目录，路由地址不能为空
            throw new BusinessException("菜单类型为目录，路由地址不能为空!");
        }
        if (MenuTypeEnum.CD.getCode().equals(dto.getMenuType().toString())
                && StringUtils.isBlank(dto.getPath())) {
            //菜单类型为菜单，路由地址不能为空
            throw new BusinessException("菜单类型为菜单，路由地址不能为空!");
        }
        if (dto.getParentBizId().equals(dto.getMenuBizId())) {
            //父级菜单不能为当前菜单
            throw new BusinessException("父级菜单不能为当前菜单！!");
        }
        if (!dto.getIsAdmin() && CommonEnum.SCOPE_SYS.getCode().equals(dto.getScope().toString())) {
            //非超级管理员不能选择系统级作用域
            throw new BusinessException("非超级管理员不能选择系统级作用域！");
        }
        //校验作用域scope字段，如果为作用域租户级所属租户id必须传值
        if(CommonEnum.SCOPE_TENANT.getCode().equals(dto.getScope().toString())
                && StringUtils.isBlank(dto.getTenantBizId())) {
            throw new BusinessException("租户级作用域，所属租户id不能为空");
        }
        //校验作用域scope字段，如果为作用域项目级所属项目id必须传值
        if(CommonEnum.SCOPE_PROJECT.getCode().equals(dto.getScope().toString())
                && StringUtils.isBlank(dto.getProjectBizId())) {
            throw new BusinessException("项目级作用域，所属项目id不能为空");
        }
    }

    /**
     * 删除菜单（逻辑删除）
     * @param menuBizId 菜单唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String menuBizId) {
        return null;
    }

    /**
     * 编辑菜单状态
     * @param menuBizId 菜单唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String menuBizId, Integer status) {
        return null;
    }

    /**
     * 校验菜单是否存在
     * @param menuBizId
     * @return
     */
    public Result<SysMenu> checkSysMenuIsExist(String menuBizId) {
        SysMenu sysMenu = iSysMenuService.queryOne(menuBizId);
        if (Objects.isNull(sysMenu)) {
            //数据不存在
            throw new BusinessException(ResultCode.NULL_ERROR.getCode(),ResultCode.NULL_ERROR.getMessage());
        }
        return Result.success(sysMenu);
    }
}
