package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.model.RelTenantRole;
import org.apache.ibatis.annotations.Param;

/**
 * <p>
 * 租户-角色关系表（正常来说一对多，加关系表方便扩展） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelTenantRoleMapper extends BaseMapper<RelTenantRole> {

    IPage<ApiRelTenantRoleListPageResponse> page(@Param("page") IPage<ApiRelTenantRoleListPageResponse> page,
                                                 @Param("request") ApiRelTenantRoleListPageRequest request);

    /**
     * 导入-选择项目分页查询（查询项目表作用域字段为当前租户级和系统级数据）
     * @param page
     * @param request
     * @return
     */
    IPage<ApiRelTenantRoleSelectPageResponse> selectProjectPage(@Param("page") IPage<ApiRelTenantRoleSelectPageResponse> page,
                                                                @Param("request") ApiRelTenantRoleSelectPageRequest request);
}
