package com.yd.user.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantproject.QueryRelTenantProjectListRequest;
import com.yd.user.feign.request.sysuser.ApiSysUserPageRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import com.yd.user.feign.response.reltenantproject.QueryRelTenantProjectListResponse;
import com.yd.user.feign.response.sysuser.ApiSysUserPageResponse;
import com.yd.user.service.model.RelTenantProject;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 租户-项目关系表（正常来说一对多，加关系表方便扩展） Mapper 接口
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface RelTenantProjectMapper extends BaseMapper<RelTenantProject> {

    IPage<ApiRelTenantProjectListPageResponse> page(@Param("page") IPage<ApiRelTenantProjectListPageResponse> page, @Param("request") ApiRelTenantProjectListPageRequest request);

    /**
     * 导入-选择项目分页查询（查询项目表作用域字段为当前租户级和系统级数据）
     * @param page
     * @param request
     * @return
     */
    IPage<ApiRelTenantProjectSelectPageResponse> selectProjectPage(@Param("page") IPage<ApiRelTenantProjectSelectPageResponse> page, @Param("request") ApiRelTenantProjectSelectPageRequest request);

    List<QueryRelTenantProjectListResponse> queryRelTenantProjectList(@Param("request") QueryRelTenantProjectListRequest request);

}
