package com.yd.user.feign.request.sysdept;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiSysDeptAddRequest {

    /**
     * 类型(1:部门 2:公司)
     */
    @NotNull(message = "部门类型不能为空")
    private Integer type;

    /**
     * 部门属性(0-未知 1-保险 2-中介)
     */
    private Integer attribute;

    /**
     * 部门名称
     */
    @NotBlank(message = "部门名称不能为空")
    private String deptName;

    /**
     * 父部门ID
     */
    @NotBlank(message = "父部门ID不能为空")
    private String parentBizId;

    /**
     * 显示顺序
     */
    private Integer orderNum;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 状态(0:停用 1:启用)
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 作用域(1:系统级（全局） 2:租户级 3:项目级)
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 所属租户ID（业务id）
     */
    private String tenantBizId;

    /**
     * 所属项目ID（业务id）
     */
    private String projectBizId;

}
