package com.yd.user.feign.request.reltenantdept;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

@Data
public class ApiRelTenantDeptListAddRequest {

    /**
     * 租户唯一标识(业务ID)
     */
    @NotBlank(message = "租户唯一标识(业务ID)不能为空")
    private String tenantBizId;

    /**
     * 部门唯一标识(业务ID) 列表（选中列表）
     */
    @NotEmpty(message = "部门唯一标识(业务ID) 列表（选中列表）不能为空")
    private List<String> deptBizIdList;
}
