package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reluserrole.ApiCandidateProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiCandidateTenantUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedTenantUserRolePageRequest;
import com.yd.user.feign.response.reluserrole.ApiCandidateProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateTenantUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRolePageResponse;
import com.yd.user.service.dto.RelUserRoleDto;
import com.yd.user.service.model.RelUserRole;
import com.yd.user.service.dao.RelUserRoleMapper;
import com.yd.user.service.service.IRelUserRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 用户-角色关系表（多对多关系） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelUserRoleServiceImpl extends ServiceImpl<RelUserRoleMapper, RelUserRole> implements IRelUserRoleService {

    /**
     * 删除租户用户角色关系
     * @param tenantBizId
     * @param userBizId
     */
    @Override
    public void delRelTenantUserRole(String tenantBizId, String userBizId) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getTenantBizId,tenantBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
        );
    }

    /**
     * 删除租户用户角色关系
     * @param tenantBizId
     * @param userBizId
     */
    @Override
    public void delRelTenantUserRole(String tenantBizId,
                                     String userBizId,
                                     List<String> roleBizIdList,
                                     Integer type) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getType,type)
                .eq(RelUserRole::getTenantBizId,tenantBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
                .in(RelUserRole::getRoleBizId,roleBizIdList)
        );
    }

    /**
     * 删除项目用户角色关系
     * @param projectBizId
     * @param userBizId
     */
    @Override
    public void delRelProjectUserRole(String projectBizId, String userBizId) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getProjectBizId,projectBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
        );
    }

    /**
     * 删除项目用户角色关系
     * @param projectBizId
     * @param userBizId
     */
    @Override
    public void delRelProjectUserRole(
                                     String tenantBizId,
                                     String projectBizId,
                                     String userBizId,
                                     List<String> roleBizIdList,
                                     Integer type) {
        this.remove(new LambdaQueryWrapper<RelUserRole>()
                .eq(RelUserRole::getType,type)
                .eq(RelUserRole::getTenantBizId,tenantBizId)
                .eq(RelUserRole::getProjectBizId,projectBizId)
                .eq(RelUserRole::getUserBizId,userBizId)
                .in(RelUserRole::getRoleBizId,roleBizIdList)
        );
    }

    @Override
    public IPage<ApiCandidateTenantUserRolePageResponse> candidateTenantUserRolePage(Page<ApiCandidateTenantUserRolePageResponse> page,
                                                                                     ApiCandidateTenantUserRolePageRequest request) {
        return baseMapper.candidateTenantUserRolePage(page,request);
    }

    @Override
    public IPage<ApiSelectedTenantUserRolePageResponse> selectedTenantUserRolePage(Page<ApiSelectedTenantUserRolePageResponse> page,
                                                                                   ApiSelectedTenantUserRolePageRequest request) {
        return baseMapper.selectedTenantUserRolePage(page,request);
    }

    @Override
    public IPage<ApiCandidateProjectUserRolePageResponse> candidateProjectUserRolePage(Page<ApiCandidateProjectUserRolePageResponse> page,
                                                                                       ApiCandidateProjectUserRolePageRequest request) {
        return baseMapper.candidateProjectUserRolePage(page,request);
    }

    @Override
    public IPage<ApiSelectedProjectUserRolePageResponse> selectedProjectUserRolePage(Page<ApiSelectedProjectUserRolePageResponse> page,
                                                                                     ApiSelectedProjectUserRolePageRequest request) {
        return baseMapper.selectedProjectUserRolePage(page,request);
    }

    /**
     * 根据条件查询用户角色列表
     * @param dto
     * @return
     */
    @Override
    public List<RelUserRole> queryList(RelUserRoleDto dto) {
        List<RelUserRole> list = baseMapper.selectList(new LambdaQueryWrapper<RelUserRole>()
                .eq(!Objects.isNull(dto.getId()),RelUserRole::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelUserRole::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getProjectBizId()),RelUserRole::getProjectBizId,dto.getProjectBizId())
                .eq(StringUtils.isNotBlank(dto.getUserBizId()),RelUserRole::getUserBizId,dto.getUserBizId())
                .eq(StringUtils.isNotBlank(dto.getRoleBizId()),RelUserRole::getRoleBizId,dto.getRoleBizId())
                .eq(!Objects.isNull(dto.getType()),RelUserRole::getType,dto.getType())
        );
        return list;
    }
}
