package com.yd.user.feign.request.reluserrole;

import com.yd.common.dto.PageDto;
import lombok.Data;

import javax.validation.constraints.NotBlank;

@Data
public class ApiSelectedTenantUserRolePageRequest extends PageDto {

    /**
     * 租户ID（业务id）
     */
    @NotBlank(message = "租户ID（业务id）不能为空")
    private String tenantBizId;

    /**
     * 用户ID（业务id）
     */
    @NotBlank(message = "用户ID（业务id）不能为空")
    private String userBizId;

    /**
     * 角色名称
     */
    private String roleName;
}
